<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dream extends Model 
{

    protected $table = 'dreams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'description', 'status', 'user_name', 'interpreter_name', 'plan_id', 'country_id', 'voice_record', 'marital_status', 'age', 'gender', 'employed', 'have_childrens', 'dream_time', 'mental_illness', 'guidance_prayer', 'notification');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function country()
    {
        return $this->hasOne('App\Models\Country');
    }

    public function plan()
    {
        return $this->belongsTo('App\Models\Plan');
    }

    public function transaction()
    {
        return $this->hasOne('App\Models\Transaction');
    }

    public function dreamComments()
    {
        return $this->hasMany('App\Models\DreamComment');
    }

}